﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Chapter5__Neapolitan_
{
    class RandomSet
    {
        int[] data;
        int index;
        public RandomSet()
        {
            data = new int[10000];
            index = 0;
        }
        public void Insert(int x)
        {
            data[index] = x;
            index++;
        }
        public bool IsEmpty()
        {
            return (index == 0);
        }
        public int GetRand()
        {
            if (!IsEmpty())
            {
                Random rand = new Random();
                return data[rand.Next(index)];
            }
            else
                return 0;
        }
    }
    class Program
    {
        /// <summary>
        /// ////////////// 8 Queen
        /// </summary>
        static int[] col;
        static int[] LeftDiag;
        static int[] RightDiag;
        static int n;
        /// <summary>
        /// ////////////// Set & Knapsack
        /// </summary>
        static bool[] Include;
        static int[] w;
        static int W;
        static int[] p;
        static int MaxProfit;
        static bool[] BestSet;
        static int NumBest;
        /// <summary>
        /// ////////////// Hamiltonian
        /// </summary>
        static int[] vindex;
        static bool[,] W_Mat;
        static int startVertex;

        #region Question 3
        static void expand_NQueen(int i)
        {
            for (int j = 1; j <= n; j++)
            {
                col[i + 1] = j;
                if (promising(i + 1))
                {
                    if (i + 1 == n)
                    {
                        print();
                    }
                    else
                    {
                        expand_NQueen(i + 1);
                    }
                }
            }
        }
        #endregion
        #region Question 4
        static void NQueen(int i)
        {
            if (Promising(i))
            {
                if (i == n)
                {
                    print();
                }
                else
                {
                    for (int j = 1; j <= n; j++)
                    {
                        col[i + 1] = j;
                        NQueen(i + 1);
                    }
                }
            }
        }
        static bool promising(int i)
        {
            for (int j = 1; j < i; j++)
                if (col[i] == col[j] || Math.Abs(col[i] - col[j]) == i - j)
                    return false;
            return true;
        }
        static void print()
        {
            int[,] a = new int[n + 1, n + 1];
            for (int i = 1; i <= n; i++)
                a[i, col[i]] = 1;
            for (int i = 1; i <= n; i++)
            {
                for (int j = 1; j <= n; j++)
                    Console.Write(a[i, j] + " ");
                Console.WriteLine();
            }
            Console.WriteLine();
            Console.WriteLine();
        }
        #endregion
        #region Question 7
        static bool Promising(int i)
        {
            LeftDiag[i] = col[i] - i;
            RightDiag[i] = col[i] + i;
            for (int j = 1; j < i; j++)
                if (col[i] == col[j] || LeftDiag[i] == LeftDiag[j] || RightDiag[i] == RightDiag[j])
                    return false;
            return true;
        }
        #endregion
        #region Question 8
        static void Queen(int i, ref bool isFind)
        {
            if (!isFind)
            {
                if (Promising(i))
                {
                    if (i == n)
                    {
                        print();
                        isFind = true;
                    }
                    else
                    {
                        for (int j = 1; j <= n; j++)
                        {
                            col[i + 1] = j;
                            Queen(i + 1, ref isFind);
                        }
                    }
                }
            }
        }
        #endregion
        #region Question 12
        static void Queen(int i, ref int count)
        {
            count++;
            if (Promising(i))
            {
                if (i < n)
                {
                    for (int j = 1; j <= n; j++)
                    {
                        col[i + 1] = j;
                        Queen(i + 1, ref count);
                    }
                }
            }
        }
        #endregion
        #region Question 13
        static void Sum_Of_Subsets(int i, int weight, int total)
        {
            if (setPromising(i, weight, total))
            {
                if (weight == W)
                    Print(Include);
                else
                {
                    Include[i + 1] = true;
                    Sum_Of_Subsets(i + 1, weight + w[i + 1], total - w[i + 1]);
                    Include[i + 1] = false;
                    Sum_Of_Subsets(i + 1, weight, total - w[i + 1]);
                }
            }
        }
        static void Print(bool[] Include)
        {
            for (int i = 1; i < Include.Length; i++)
                if (Include[i])
                    Console.Write(w[i] + " ");
            Console.WriteLine();
        }
        static bool setPromising(int i, int weight, int total)
        {
            return ((weight + total >= W) && (weight == W || weight + w[i + 1] <= W));
        }
        #endregion
        #region Question 15
        static bool setPromising(int weight, int total)
        {
            return (weight + total >= W && weight <= W);
        }
        #endregion
        #region Question 16
        static void Sum_Of_Subsets(int i, int weight, int total, ref bool isFind)
        {
            if (!isFind)
            {
                if (setPromising(i, weight, total))
                {
                    if (weight == W)
                    {
                        isFind = true;
                        Print(Include);
                    }
                    else
                    {
                        Include[i + 1] = true;
                        Sum_Of_Subsets(i + 1, weight + w[i + 1], total - w[i + 1], ref isFind);
                        Include[i + 1] = false;
                        Sum_Of_Subsets(i + 1, weight, total - w[i + 1], ref isFind);
                    }
                }
            }
        }
        #endregion
        #region Question 17
        static int Set_MontCarlo()
        {
            int NumNodes = 1, MProm = 1, m = 1, t = 2, i = 0;
            int weight = 0, total = 45;
            while (m != 0 && i < w.Length - 1)
            {
                RandomSet randSet = new RandomSet();
                MProm *= m;
                NumNodes += (MProm * t);
                m = 0;
                Include[i + 1] = true;
                if (setPromising(i + 1, weight + w[i + 1], total - w[i + 1]))
                {
                    randSet.Insert(1);
                    m++;
                }
                Include[i + 1] = false;
                if (setPromising(i + 1, weight, total - w[i + 1]))
                {
                    randSet.Insert(0);
                    m++;
                }
                if (m != 0)
                {
                    int child = randSet.GetRand();
                    total -= w[i + 1];
                    if (child == 1)
                    {
                        weight += w[i + 1];
                        i++;
                        Include[i] = true;
                    }
                    else
                    {
                        i++;
                        Include[i] = false;
                    }
                }
            }
            return NumNodes;
        }
        #endregion
        #region Question 19
        static void Coloring(int n, bool[,] Mat, out int[] Result)
        {
            int NotColored = 0;
            List<int> SameColor_Vertices = new List<int>();
            Result = new int[n];
            int color = 1;
            for (int i = 0; i < n; i++)
            {
                SameColor_Vertices.Clear();
                if (Result[i] == NotColored)
                {
                    Result[i] = color;
                    SameColor_Vertices.Add(i);
                    for (int j = i + 1; j < n; j++)
                    {
                        if (Result[j] == NotColored)
                        {
                            bool conflictFound = false;
                            for (int k = 0; k < SameColor_Vertices.Count; k++)
                            {
                                int vertex = SameColor_Vertices[k];
                                if (Mat[j, vertex])
                                {
                                    conflictFound = true;
                                }
                            }
                            if (!conflictFound)
                            {
                                Result[j] = color;
                                SameColor_Vertices.Add(j);
                            }
                        }
                    }
                    color++;
                }
            }
        }
        #endregion
        #region Question 24
        static void TwoColoring(int i)
        {
            if (Color_Promising(i))
            {
                if (i == n)
                    col_print();
                else
                {
                    col[i + 1] = 1;
                    TwoColoring(i + 1);
                    col[i + 1] = 2;
                    TwoColoring(i + 1);
                }
            }
        }
        static bool Color_Promising(int i)
        {
            for (int j = 1; j < i; j++)
            {
                if (W_Mat[i - 1, j - 1] && col[i] == col[j])
                {
                    return false;
                }
            }
            return true;
        }
        static void col_print()
        {
            string color = string.Empty;
            for (int i = 1; i < col.Length; i++)
            {
                Console.Write("  V" + i.ToString() + ":");
                if (col[i] == 1)
                {
                    color = "red";
                }
                else if (col[i] == 2)
                {
                    color = "green";
                }
                else if (col[i] == 3)
                {
                    color = "white";
                }
                else
                {
                    color = "Color" + col[i];
                }
                Console.Write(color);
            }
            Console.WriteLine("\n");
        }
        #endregion
        #region Question 27,28,29
        static void Ham_Print()
        {
            Console.WriteLine();
            for (int i = 0; i < n; i++)
            {
                Console.Write(vindex[i] + "-->");
            }
            Console.WriteLine(vindex[0]);
        }
        static bool Ham_Promising(int i)
        {
            if (i == n - 1 && !W_Mat[vindex[0], vindex[n - 1]])
                return false;
            if (i > 0 && !W_Mat[vindex[i - 1], vindex[i]])
                return false;
            for (int j = 0; j < i; j++)
            {
                if (vindex[j] == vindex[i])
                    return false;
            }
            return true;
        }
        static void Hamiltonian(int i, ref bool isFind)
        {
            if (!isFind)
            {
                if (Ham_Promising(i))
                {
                    if (i == n - 1)
                    {
                        Ham_Print();
                        isFind = true;
                    }
                    else
                    {
                        for (int j = 1; j <= n; j++)
                        {
                            vindex[i + 1] = j;
                            Hamiltonian(i + 1, ref isFind);
                        }
                    }
                }
            }
        }
        #endregion
        #region Question 31
        static int Ham_MontCarlo()
        {
            int NumNodes = 1, MProm = 1, m = 1, t = n, i = 0;
            while (m != 0)
            {
                RandomSet randomSet = new RandomSet();
                MProm *= m;
                NumNodes += (MProm * t);
                m = 0;
                if (i < n - 1)
                {
                    for (int j = 1; j <= n; j++)
                    {
                        vindex[i + 1] = j;
                        if (Ham_Promising(i + 1))
                        {
                            randomSet.Insert(j);
                            m++;
                        }
                    }
                    if (m != 0)
                    {
                        i++;
                        vindex[i] = randomSet.GetRand();
                    }
                }
            }
            return NumNodes;
        }
        #endregion
        #region Question 36
        static void Knapsack(int i, int profit, int weight, bool isRightMove)
        {
            if (weight <= W && profit > MaxProfit)
            {
                MaxProfit = profit;
                NumBest = i;
                Array.Copy(Include, BestSet, Include.Length); // copy Include to BestSet
            }
            if (isRightMove)
                if (!Kna_Promising(i, profit, weight))
                    return;
            if (i == n)
                return;
            Include[i + 1] = true;
            Knapsack(i + 1, profit + p[i + 1], weight + w[i + 1], false);
            Include[i + 1] = false;
            Knapsack(i + 1, profit, weight, true);
        }
        static bool Kna_Promising(int i, int profit, int weight)
        {
            int j, k;
            int totweight;
            float bound;
            if (weight >= W)
                return false;
            else
            {
                j = i + 1;
                bound = profit;
                totweight = weight;
                while (j <= n && totweight + w[j] <= W)
                {
                    totweight += w[j];
                    bound += p[j];
                    j++;
                }
                k = j;
                if (k <= n)
                    bound += ((W - totweight) * ((float)p[k] / w[k]));
                return bound > MaxProfit;
            }
        }
        static void Kna_Sort(int[] w, int[] p)
        {
            float[] PbarW = new float[n + 1];
            for (int i = 1; i < PbarW.Length; i++)
                PbarW[i] = (float)p[i] / w[i];
            for (int i = 2; i < PbarW.Length; i++)
                for (int j = 1; j < PbarW.Length - i; j++)
                {
                    if (PbarW[j] < PbarW[j + 1])
                    {
                        float tmpF = PbarW[j];
                        PbarW[j] = PbarW[j + 1];
                        PbarW[j + 1] = tmpF;
                        int tmpI = p[j];
                        p[j] = p[j + 1];
                        p[j + 1] = tmpI;
                        tmpI = w[j];
                        w[j] = w[j + 1];
                        w[j + 1] = tmpI;
                    }
                }
        }
        #endregion
        #region Question 37
        static int Kna_MontCarlo()
        {
            int NumNodes = 1, MProm = 1, m = 1, t = 2, i = 0;
            int weight = 0, profit = 0;
            while (m != 0 && i < w.Length - 1)
            {
                RandomSet rset = new RandomSet();
                MProm *= m;
                NumNodes += (MProm * t);
                m = 0;
                Include[i + 1] = true;
                if (Kna_Promising(i + 1, profit + p[i + 1], weight + w[i + 1]))
                {
                    rset.Insert(1);
                    m++;
                }
                Include[i + 1] = false;
                if (Kna_Promising(i + 1, profit, weight))
                {
                    rset.Insert(0);
                    m++;
                }
                if (m != 0)
                {
                    int child = rset.GetRand();
                    if (child == 1)
                    {
                        weight += w[i + 1];
                        profit += p[i + 1];
                        Include[++i] = true;
                    }
                    else
                        Include[++i] = false;
                }
            }
            return NumNodes;
        }
        #endregion
        #region Question 39
        static void Queen_Invariant(int i)
        {
            if (Promising(i))
            {
                if (i == n)
                {
                    if (IsInvariant())
                        print();
                }
                else
                {
                    for (int j = 1; j <= n; j++)
                    {
                        col[i + 1] = j;
                        Queen_Invariant(i + 1);
                    }
                }
            }
        }
        static bool IsInvariant()
        {
            int N = n + 1;
            int[,] a = new int[N, N];
            for (int i = 1; i < N; i++)
            {
                a[i, col[i]] = 1;
            }
            for (int i = 1; i < N; i++)
            {
                for (int j = 1; j < N; j++)
                {
                    if (a[i, j] != a[N - i, N - j])
                    {
                        return false;
                    }
                }
            }
            return true;
        }
        #endregion
        #region Question 41
        static void Sum_Of_Subsets_inList(int i, int weight, int total, List<bool> IncludeList)
        {
            if (setPromising(i, weight, total))
            {
                if (weight == W)
                    Print(IncludeList);
                else
                {
                    IncludeList.Add(true); // Add element to end of list
                    Sum_Of_Subsets_inList(i + 1, weight + w[i + 1], total - w[i + 1], IncludeList);
                    IncludeList.RemoveAt(i + 1); // Remove last element
                    IncludeList.Add(false); // Add element to end of list
                    Sum_Of_Subsets_inList(i + 1, weight, total - w[i + 1], IncludeList);
                    IncludeList.RemoveAt(i + 1); // Remove last element
                }
            }
        }
        static void Print(List<bool> Include)
        {
            for (int i = 1; i < Include.Count; i++)
                if (Include[i])
                    Console.Write(w[i] + " ");
            Console.WriteLine();
        }
        #endregion
        #region Question 43
        static void Hamiltonian_LeastCost(int i, int[,] Weight, ref int MinCost, int[] MinCircuit)
        {
            if (Ham_Promising(i))
            {
                if (i == n - 1)
                {
                    int CirCost = HamCircuit_Cost(Weight);
                    if (CirCost < MinCost)
                    {
                        MinCost = CirCost;
                        Array.Copy(vindex, MinCircuit, vindex.Length); // copy vindex into MinCircuit
                    }
                }
                else
                {
                    for (int j = 1; j <= n; j++)
                    {
                        vindex[i + 1] = j;
                        Hamiltonian_LeastCost(i + 1, Weight, ref MinCost, MinCircuit);
                    }
                }
            }
        }
        static int HamCircuit_Cost(int[,] Weight)
        {
            int result = 0;
            for (int i = 1; i < vindex.Length; i++)
            {
                result += Weight[vindex[i - 1], vindex[i]];
            }
            return result;
        }
        #endregion
        #region Question 44
        static void Knapsack_inList(int i, int profit, int weight, List<bool> IncludeList, ref List<bool> BestSetList)
        {
            if (weight <= W && profit > MaxProfit)
            {
                MaxProfit = profit;
                NumBest = i;
                BestSetList = new List<bool>(IncludeList); // copy IncludeList to BestSetList
                while (BestSetList.Count < w.Length)
                {
                    BestSetList.Add(false); // remaining items doesn't cache
                }
            }
            if (Kna_Promising(i, profit, weight) && i < n)
            {
                IncludeList.Add(true); // Add true to end of list
                Knapsack_inList(i + 1, profit + p[i + 1], weight + w[i + 1], IncludeList, ref BestSetList);
                IncludeList.RemoveAt(i + 1); // Remove last element
                IncludeList.Add(false); // Add false to end of list
                Knapsack_inList(i + 1, profit, weight, IncludeList, ref BestSetList);
                IncludeList.RemoveAt(i + 1); // Remove last element
            }
        }
        #endregion

        static void Main(string[] args)
        {
            bool T = true, F = false;
            Console.WriteLine("-------------------------------------------------------------// 3,4");
            n = 4;
            Console.WriteLine();
            col = new int[n + 1];
            LeftDiag = new int[n + 1];
            RightDiag = new int[n + 1];
            expand_NQueen(0);
            Console.WriteLine("-------------------------------------------------------------// 8");
            bool isFind = false;
            Queen(0, ref isFind);
            Console.WriteLine("-------------------------------------------------------------// 12");
            int count = 0;
            Queen(0, ref count);
            Console.WriteLine(count);
            Console.WriteLine("-------------------------------------------------------------// 13");
            w = new int[] { -1, 2, 10, 13, 17, 22, 42 };
            Include = new bool[w.Length];
            W = 52;
            Sum_Of_Subsets(0, 0, 106);
            Console.WriteLine("-------------------------------------------------------------// 16");
            isFind = false;
            Sum_Of_Subsets(0, 0, 106, ref isFind);
            Console.WriteLine("-------------------------------------------------------------// 17");
            Console.WriteLine(Set_MontCarlo());
            Console.WriteLine("-------------------------------------------------------------// 20");
            bool[,] mat = {
                          {   F,    T,    F,    T,   F,   F   },
                          {   T,    F,    T,    F,   T,   F   },
                          {   F,    T,    F,    F,   F,   T   },
                          {   T,    F,    F,    F,   T,   F   },
                          {   F,    T,    F,    T,   F,   T   },
                          {   F,    F,    T,    F,   T,   F   }
                          };
            W_Mat = mat;
            n = mat.GetLength(0);
            col = new int[n + 1];
            int[] res;
            Coloring(n, mat, out res);
            for (int i = 0; i < res.Length; i++)
                Console.Write("V" + (i + 1) + ":Color" + res[i] + ", ");
            Console.WriteLine();
            Console.WriteLine("-------------------------------------------------------------// 24");
            TwoColoring(0);
            Console.WriteLine("-------------------------------------------------------------// 27,28,29");
            W_Mat = new bool[,] {
                                 {  F,  F,  F,  F,  F,  F,  F,  F,  F,  F,  F,  F,  F   },
                                 {  F,  F,  T,  F,  F,  T,  F,  F,  F,  F,  F,  F,  F   },
                                 {  F,  T,  F,  T,  F,  F,  F,  T,  T,  F,  F,  F,  F   },
                                 {  F,  F,  T,  F,  T,  F,  F,  F,  T,  F,  F,  F,  F   },
                                 {  F,  F,  F,  T,  F,  F,  F,  F,  F,  T,  F,  F,  F   },
                                 {  F,  T,  F,  F,  F,  F,  T,  F,  F,  F,  T,  F,  F   },
                                 {  F,  F,  F,  F,  F,  T,  F,  T,  F,  F,  F,  T,  F   },
                                 {  F,  F,  T,  F,  F,  F,  T,  F,  T,  F,  F,  F,  F   },
                                 {  F,  F,  T,  T,  F,  F,  F,  T,  F,  T,  F,  F,  T   },
                                 {  F,  F,  F,  F,  T,  F,  F,  F,  T,  F,  F,  F,  T   },
                                 {  F,  F,  F,  F,  F,  T,  F,  F,  F,  F,  F,  T,  F   },
                                 {  F,  F,  F,  F,  F,  F,  T,  F,  F,  F,  T,  F,  T   },
                                 {  F,  F,  F,  F,  F,  F,  F,  F,  T,  T,  F,  T,  F   }
                                 };
            n = W_Mat.GetLength(0) - 1;
            vindex = new int[n];
            startVertex = 1;
            vindex[0] = startVertex;
            isFind = false;
            Hamiltonian(0, ref isFind);
            Console.WriteLine("-------------------------------------------------------------// 31");
            Console.WriteLine(Ham_MontCarlo());
            Console.WriteLine("-------------------------------------------------------------// 34,36");
            w = new int[] { 0, 2, 5, 7, 3, 1 };
            p = new int[] { 0, 20, 30, 35, 12, 3 };
            n = w.Length - 1;
            W = 15;
            NumBest = 0;
            MaxProfit = 0;
            Kna_Sort(w, p);
            Include = new bool[n + 1];
            BestSet = new bool[n + 1];
            Knapsack(0, 0, 0, true);
            Console.WriteLine(MaxProfit);
            for (int i = 1; i < BestSet.Length; i++)
                Console.Write(BestSet[i] + " ");
            Console.WriteLine("\n-------------------------------------------------------------// 37");
            NumBest = 0;
            MaxProfit = 0;
            BestSet = new bool[n + 1];
            Console.WriteLine(Kna_MontCarlo());
            Console.WriteLine("-------------------------------------------------------------// 39");
            n = 8;
            col = new int[n + 1];
            LeftDiag = new int[n + 1];
            RightDiag = new int[n + 1];
            Queen_Invariant(0);
            Console.WriteLine("-------------------------------------------------------------// 41");
            w = new int[] { -1, 2, 10, 13, 17, 22, 42 };
            List<bool> include = new List<bool>();
            include.Add(false);
            W = 52;
            Sum_Of_Subsets_inList(0, 0, 106, include);
            Console.WriteLine("-------------------------------------------------------------// 43");
            n = W_Mat.GetLength(0) - 1;
            vindex = new int[n];
            startVertex = 1;
            vindex[0] = startVertex;
            int MinCost = 1000000;
            int[] MinCircuit = new int[n];
            Hamiltonian_LeastCost(0, new int[n + 1, n + 1], ref MinCost, MinCircuit);
            Array.Copy(MinCircuit, vindex, n); // copy MinCircuit to vindex for print!
            Ham_Print();
            Console.WriteLine("-------------------------------------------------------------// 44");
            w = new int[] { 0, 2, 5, 7, 3, 1 };
            p = new int[] { 0, 20, 30, 35, 12, 3 };
            n = w.Length - 1;
            W = 19;
            NumBest = 0;
            MaxProfit = 0;
            Kna_Sort(w, p);
            List<bool> bestSet = new List<bool>();
            include = new List<bool>();
            include.Add(false);
            Knapsack_inList(0, 0, 0, include, ref bestSet);
            Console.WriteLine(MaxProfit);
            for (int i = 1; i < bestSet.Count; i++)
                Console.Write(bestSet[i] + " ");
            Console.ReadKey();
        }
    }
}
